<?php
// etc/pay/zarinpal/back.php

include '../../../config.php';

// تابع ساده برای ارسال پیام با ربات
function sendMessage($chat_id, $text, $parse_mode = 'HTML') {
    global $API_KC;
    $url = "https://api.telegram.org/bot" . $API_KC . "/sendMessage";
    $data = ['chat_id' => $chat_id, 'text' => $text, 'parse_mode' => $parse_mode];
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

if (!isset($merichentzarin) || empty($merichentzarin)) {
    die("پیکربندی درگاه پرداخت (مرچنت کد) یافت نشد.");
}

$Authority = $_GET['Authority'] ?? null;
$user_id = $_GET['id'] ?? null;
$amount_toman = (int)($_GET['amount'] ?? 0);
$amount_rial = $amount_toman * 10;

if (!$Authority || !$user_id || $amount_toman < 1000) {
    die("اطلاعات بازگشتی نامعتبر است.");
}

$data = array("merchant_id" => $merichentzarin, "authority" => $Authority, "amount" => $amount_rial);
$jsonData = json_encode($data);

$ch = curl_init('https://api.zarinpal.com/pg/v4/payment/verify.json');
curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v4');
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    'Content-Type: application/json',
    'Content-Length: ' . strlen($jsonData)
));

$result = curl_exec($ch);
$err = curl_error($ch);
curl_close($ch);
$result = json_decode($result, true);

$base_page_style = '<!DOCTYPE html><html lang="fa" dir="rtl"><head><meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0"><title>{TITLE}</title><style>body{font-family: sans-serif; display: grid; place-items: center; min-height: 100vh; background: #f9f9f9;}.card{background: #fff; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.05); padding: 30px; text-align: center;}h2{color: {COLOR}; margin-bottom: 15px;}p{font-size: 1.1em; margin-bottom: 25px;}a{display: inline-block; padding: 12px 25px; background: #007aff; color: white; text-decoration: none; border-radius: 8px; font-weight: bold;}</style></head><body><div class="card"><h2>{ICON} {TITLE}</h2><p>{MESSAGE}</p><a href="https://t.me/' . $bottag . '">بازگشت به ربات</a></div></body></html>';

$success_page = str_replace(
    ['{TITLE}', '{COLOR}', '{ICON}', '{MESSAGE}'],
    ['پرداخت موفق', '#28a745', '✅', 'مبلغ ' . number_format($amount_toman) . ' تومان با موفقیت به حساب شما اضافه شد.'],
    $base_page_style
);

$fail_page = str_replace(
    ['{TITLE}', '{COLOR}', '{ICON}', '{MESSAGE}'],
    ['پرداخت ناموفق', '#dc3545', '❌', 'پرداخت شما با خطا مواجه شد یا توسط شما لغو گردید.'],
    $base_page_style
);

if ($err) {
    echo "cURL Error: " . $err;
    exit;
}

if (isset($result['data']['code']) && ($result['data']['code'] == 100 || $result['data']['code'] == 101)) {

    $ref_id = $result['data']['ref_id'] ?? 'N/A';

    if ($result['data']['code'] == 101) {
        echo str_replace(
            ['{TITLE}', '{COLOR}', '{ICON}', '{MESSAGE}'],
            ['تراکنش تکراری', '#ffc107', '⚠️', 'این تراکنش قبلا تایید شده است.<br>کد پیگیری: ' . $ref_id],
            $base_page_style
        );
        exit;
    }

    $stmt = $connect->prepare("UPDATE user SET balancerial = balancerial + ? WHERE id = ?");
    $stmt->bind_param("is", $amount_toman, $user_id);
    $stmt->execute();

    if ($stmt->affected_rows > 0) {

        $stmt_log = $connect->prepare("INSERT INTO rial_charges (user_id, amount, authority, ref_id, status, created_at) VALUES (?, ?, ?, ?, 'completed', NOW())");
        $stmt_log->bind_param("siss", $user_id, $amount_toman, $Authority, $ref_id);
        $stmt_log->execute();

        $sets_query = $connect->query("SELECT balanceinvite FROM settings LIMIT 1");
        $settings_row = $sets_query->fetch_assoc();
        $invite_percent = $settings_row['balanceinvite'] ?? 0;

        $user_for_invite_res = $connect->query("SELECT inviter FROM user WHERE id = '$user_id' LIMIT 1");

        if ($user_for_invite_res && $user_for_invite_res->num_rows > 0) {
            $user_for_invite = $user_for_invite_res->fetch_assoc();

            if (!empty($user_for_invite['inviter']) && $invite_percent > 0) {
                $inviter_id = $user_for_invite['inviter'];

                $bonus_amount = (int)(($amount_toman * $invite_percent) / 100);

                if ($bonus_amount > 0) {
                    $connect->query("UPDATE user SET balancerial = balancerial + $bonus_amount WHERE id = '$inviter_id'");

                    $msg_inviter = "💰 تبریک! یکی از زیرمجموعه‌های شما حساب خود را شارژ کرد.\n\n" .
                        "🎁 مبلغ " . number_format($bonus_amount) . " تومان پاداش به کیف پول شما اضافه شد.";
                    sendMessage($inviter_id, $msg_inviter);
                }
            }
        }
        $user_message = "✅ پرداخت شما به مبلغ " . number_format($amount_toman) . " تومان با موفقیت انجام شد و حساب شما شارژ گردید.\n🔖 کد پیگیری: <code>$ref_id</code>";
        sendMessage($user_id, $user_message);

        $admin_message = "✅ <b>واریز آنلاین (زرین پال)</b>\n\n"
            . "👤 کاربر: `$user_id`\n"
            . "💳 مبلغ: " . number_format($amount_toman) . " تومان\n"
            . "🔖 کد پیگیری: `$ref_id`";
        if(isset($admins[0])) sendMessage($admins[0], $admin_message, 'HTML');

        echo $success_page;

    } else {
        $admin_message = "⚠️ <b>خطای حساس درگاه پرداخت (DB)</b>\n\n"
            . "پرداخت با موفقیت انجام شد اما موجودی کاربر آپدیت نشد!\n"
            . "👤 کاربر: `$user_id`\n"
            . "💳 مبلغ: " . number_format($amount_toman) . " تومان\n"
            . "🔖 کد پیگیری: `$ref_id`\n\n"
            . "!! لطفا دستی بررسی کنید !!";
        if(isset($admins[0])) sendMessage($admins[0], $admin_message, 'HTML');

        sendMessage($user_id, "✅ پرداخت شما موفق بود. موجودی شما به زودی توسط پشتیبانی آپدیت خواهد شد (خطای سیستمی).");
        echo $success_page;
    }

} else {

    $error_message = $result['errors']['message'] ?? 'تراکنش ناموفق بود.';

    $stmt_log_fail = $connect->prepare("INSERT INTO rial_charges (user_id, amount, authority, status, created_at) VALUES (?, ?, ?, 'failed', NOW())");
    $stmt_log_fail->bind_param("sis", $user_id, $amount_toman, $Authority);
    $stmt_log_fail->execute();

    sendMessage($user_id, "❌ پرداخت شما ناموفق بود.");

    echo str_replace('{MESSAGE}', 'پرداخت ناموفق بود.', $fail_page);
}
?>